% Function: This is function that formats the experimental data into the
% desired matrix format (when using 3 plates), this is done independently
% for each replicate

% Inputs:
% Plate(1/3)Cell - A cell from MultiPlexAnlys_XMLImport that contains the
%    unformatted data
% ProbeWell_(1/3) - A list that specifies the well number for each of the
%    probes, in the order to match the list with the probe names
% BeadRegions - A list with the all the IP bead regions used
% ShiftList_(1/3) - A list that that rearranges the data from the xml order
%    to a desired format for display figures 

% Outputs:
% MatrixOutput - This exports the median value for each of the ip/probe
%    combinations, formatted as a matrix 
% CellOutput - A cell array, where each entry has all the bead fluorescent
%    values for a given ip/probe, again formatted in as a matrix 

function [MatrixOutput, CellOutput] = MultiPlexMatrixCold_3Plates(Plate1Cell,...
Plate2Cell,Plate3Cell,ProbeWell_1,ProbeWell_2,ProbeWell_3,...
BeadRegions,ShiftList_1,ShiftList_2,ShiftList_3)

Probes_N1 = length(ProbeWell_1);
Probes_N2 = length(ProbeWell_2);
Probes_N3 = length(ProbeWell_3);
Probe_N = Probes_N1+Probes_N2+Probes_N3;
Bead_N = length(BeadRegions);

MatrixOutput = zeros(Probe_N,Bead_N);
CellOutput = cell(Probe_N,Bead_N);

for Bead_i = 1:Bead_N
    
    for alpha = 1:Probes_N1
        
        IndexOfWell_1 = ProbeWell_1(alpha);
        CellIndex_1 = (IndexOfWell_1-1)*Bead_N + Bead_i;
        
        ShiftPos_1 = ShiftList_1(alpha);
        
        CellOutput{ShiftPos_1,Bead_i} = Plate1Cell{CellIndex_1};
        MatrixOutput(ShiftPos_1,Bead_i) = median(Plate1Cell{CellIndex_1});
        
    end
    
    for beta = 1:Probes_N2
        
        IndexOfWell_2 = ProbeWell_2(beta);
        CellIndex_2 = (IndexOfWell_2-1)*Bead_N + Bead_i;
        
        ShiftPos_2 = ShiftList_2(beta);

        CellOutput{ShiftPos_2,Bead_i} = Plate2Cell{CellIndex_2};
        MatrixOutput(ShiftPos_2,Bead_i) = median(Plate2Cell{CellIndex_2});
        
    end
    
    for gamma = 1:Probes_N3
        
        IndexOfWell_3 = ProbeWell_3(gamma);
        CellIndex_3 = (IndexOfWell_3-1)*Bead_N + Bead_i;
        
        ShiftPos_3 = ShiftList_3(gamma);

        CellOutput{ShiftPos_3,Bead_i} = Plate3Cell{CellIndex_3};
        MatrixOutput(ShiftPos_3,Bead_i) = median(Plate3Cell{CellIndex_3});
        
    end
    
    
end